<?php
/*
Template Name: Search Video
*/

$authorization_token = get_option('vimeo_authorization_token');
$user_id=get_option('vimeo_authorization_id');


if (isset($_POST['create_post'])) {
   
    if (isset($_POST['selected_videos']) && is_array($_POST['selected_videos'])) {
        for($i = 0; $i < count($_POST['selected_videos']); $i++) {
        $selectedVideoIds = $_POST['selected_videos'][$i];
        $post_title = $_POST['selected_videos_name'][$i];
        $post_content = $_POST['selected_videos_content'][$i]."<br/>".$_POST['selected_videos_description'][$i];
        
       
        $post_date = $_POST['selected_videos_date'][$i];
        $post_type = $_POST['selected_videos_type'][$i];
            if($post_type == 'public'){
                $post_type='Public Content';
            }
            else{
                $post_type='Members Only Content';  
            }
        // Create the post with custom post type "video"
        $new_post = array(
            'post_title' => $post_title,
            
            'post_status' => 'draft',
            'post_type' => 'video-posts' // Replace 'video' with your custom post type name
        );

        $post_id = wp_insert_post($new_post);

        if ($post_id) {
            add_post_meta($post_id, 'vimeo_embed_code', $post_content);
            add_post_meta($post_id, 'includes_video', 'Yes');
            add_post_meta($post_id, 'includes_audio', 'No');
            add_post_meta($post_id, 'post_type', 'Video');
            add_post_meta($post_id, 'members_only_content', $post_type);
            add_post_meta($post_id, 'pasic_year', 'PASIC ' .$post_date);
          
                wp_set_post_categories($post_id, array($selected_videos_tag[$i]));
            
            // add_post_meta($post_id, 'custom_field_name', 'custom_field_value');
            // add_post_meta($post_id, 'custom_field_name', 'custom_field_value');
            // add_post_meta($post_id, 'custom_field_name', 'custom_field_value');
            // add_post_meta($post_id, 'custom_field_name', 'custom_field_value');
            // echo "Post created with ID: $post_id<br>";
            $successMessage = "Post created with ID: $post_id on $post_date.";
            $successMessages[] = $successMessage;
        } else {
            echo "Error creating the post.<br>";
        }

        // print_r($_POST);exit;
        // // Perform actions with selected video IDs (e.g., create a post)
        // // You can use $selectedVideoIds to work with the selected videos.
        // // For demonstration, we will display the selected video IDs.
        // // echo "Selected Video IDs: " . implode(', ', $selectedVideoIds);
        // exit; // You may redirect or perform further actions here
    }
    } else {
        echo "No videos selected to create a post.";
    }

    foreach ($successMessages as $message) {
        echo $message . "<br>";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- Include Bootstrap Datepicker CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">
    <style type="text/css">
        .btn-success{
            background: #31bda2;
    border: 0;
    color: #fff;
    border-radius: 5px;
    font-weight: 600;
        }
    </style>
    <title>Vimeo Videos</title>
</head>
<body>

<div class="container">
    <h1 class="mt-4">Vimeo Videos</h1>
    
    <!-- Filter Input Fields -->
    <form method="post">
    <div class="row mt-4">
      
        <div class="col-md-2">
            <!-- <label for="dateFrom">From:</label> -->
            <input type="text" class="form-control datepicker" id="dateFrom" placeholder="From" name="datefrom" value="<?php if(isset($_POST['datefrom'])) { echo $_POST['datefrom']; } ?>" required autocomplete="off">
        </div>
        <div class="col-md-2">
            <!-- <label for="dateTo">To:</label> -->
            <input type="text" class="form-control datepicker" id="dateTo" placeholder="To" name="dateto" value="<?php if(isset($_POST['dateto'])) { echo $_POST['dateto']; } ?>" required autocomplete="off">
        </div>
          <div class="col-md-2">
            <!-- <label for="dateTo">To:</label> -->
             <select name="query_fields" class="form-control" errormsg="" id="query_fields">
                <option value="">Choose one</option>
                <option value="chapters" <?php if(isset($_POST['query_fields']) && $_POST['query_fields'] == 'chapters') { echo "selected"; } ?>>chapters</option>
                <option value="description" <?php if(isset($_POST['query_fields']) && $_POST['query_fields'] == 'description') { echo "selected"; } ?>>description</option>
                <option value="tags" <?php if(isset($_POST['query_fields']) && $_POST['query_fields'] == 'tags') { echo "selected"; } ?>>tags</option>
                <option value="title" <?php if(isset($_POST['query_fields']) && $_POST['query_fields'] == 'title') { echo "selected"; } ?>>title</option></select>
        </div>
         <div class="col-md-2">
            <!-- <label for="dateTo">To:</label> -->
            <input type="text" class="form-control"  placeholder="Search" name="query" id="query" value="<?php if(isset($_POST['query'])) { echo $_POST['query']; } ?>">
        </div>
 
      <!--   <div class="col-md-2">
            <input type="text" class="form-control" placeholder="URL" name="url">
        </div>
        <div class="col-md-2">
            <input type="text" class="form-control" placeholder="Direction" name="direction">
        </div>
        <div class="col-md-2">
            <input type="text" class="form-control" placeholder="Filter" name="filter">
        </div>
        <div class="col-md-2">
            <input type="text" class="form-control" placeholder="Filter Embeddable" name="filter_em">
        </div>
        <div class="col-md-2">
            <input type="text" class="form-control" placeholder="Filter Playable" name="filter_pl">
        </div> -->
         <div class="col-md-2">
            <!-- <label for="dateTo">To:</label> -->
            <input type="submit" value="Submit" class="btn btn-success">
        </div>
        
    </div>
    </form>
    <!-- Date Range Selection -->
    

    <!-- Display Content -->
    <div class="row mt-4">
        <div class="col-md-12">
     <?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $curl = curl_init();
if(isset($_POST['query_fields']) && $_POST['query_fields'] != '')
{
    // Create the API request URL to fetch videos (page 1)
    $apiUrl = "https://api.vimeo.com/users/".$user_id."/videos?page=1&per_page=100&direction=desc&query_fields={$_POST['query_fields']}&query={$_POST['query']}";
}
else{
    $apiUrl = "https://api.vimeo.com/users/".$user_id."/videos?page=1&per_page=100&direction=desc";
}
    curl_setopt_array($curl, array(
        CURLOPT_URL => $apiUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'Authorization: Bearer '.$authorization_token,
            'Cookie: __cf_bm=sF4nqjEj0XNkoYanzEBKzMTN21.4ln8FUiA.CjulWGk-1694606475-0-AVLkQnrjcm3TgQxvQVe+BHZC4jU0kI85ER3k0Th4S7CiNnqk82qUyeWBi8BleDE6iKAD0TPKksxPEahcqtE2+eY='
        ),
    ));

    $allVideos = array();
    $page = 1;

    do {
        // Fetch videos for the current page
        $response = curl_exec($curl);
        $data = json_decode($response);

        // Filter videos based on the date range
        $startDate = strtotime($_POST['datefrom']);
        $endDate = strtotime($_POST['dateto']);
            if(isset($data->data))
            {
        foreach ($data->data as $video) {
            $createdTime = strtotime($video->created_time);

            if ($createdTime >= $startDate && $createdTime <= $endDate) {
                // Add the video to the list
                $allVideos[] = $video;

            }

        }
}
        // Move to the next page
        $page++;
        if(isset($_POST['query_fields']) && $_POST['query_fields'] != '')
{
    // Create the API request URL to fetch videos (page 1)
    $apiUrl = "https://api.vimeo.com/users/3851605/videos?page={$page}&per_page=100&direction=desc&query_fields={$_POST['query_fields']}&query={$_POST['query']}";
}
else{
    $apiUrl = "https://api.vimeo.com/users/3851605/videos?page={$page}&per_page=100&direction=desc";
}
        // $apiUrl = "https://api.vimeo.com/users/3851605/videos?page={$page}&per_page=100&direction=desc&query_fields={$_POST['query_fields']}&query_fields={$_POST['query']}";
        curl_setopt($curl, CURLOPT_URL, $apiUrl);

    } while (!empty($data->data));

    curl_close($curl);

    if (!empty($allVideos)) {
          echo '<h2>Videos</h2>';
        echo ' <form method="post">';
          echo '<div class="row mt-4">
    <div class="col-md-12">
    <input type="submit" name="create_post" value="Create Post" class="btn btn-success">
    <input type="checkbox" id="select-all-checkbox"> <label for="select-all-checkbox">Select All</label>
    </div>
</div>';
            // echo '<div class="col-md-12 row">';
         
        foreach ($allVideos as $video) {
            // Display video information here as needed
            $id=explode('/',$video->uri);
         
            $id1=$id[2];
          
            
          if(isset($video->pictures->sizes))
          {
            $img_link=$video->pictures->sizes[1]->link;
          }
          else{
             $img_link="";
          }
          $video_content=$video->embed->html;
     $description = $video->description;
     $tagNames = [];
              foreach($video->tags as $tag) {
                 // $tagNames = [];
                  $tagNames[] = $tag->name;
               // echo '<p class="card-text">Tags: ' . $tag->name . '</p>';
           }
           $tagsString = implode(', ', $tagNames);
            echo '<div class="col-md-12 mb-3 ">';
            echo '<div class="card grid-c" style="    max-width: 100%;">';
            
            echo '<div class="img-div">';
            echo '<textarea name="selected_videos_content[]" style="display:none;">';
echo $video_content;
echo '</textarea>';

echo '<textarea name="selected_videos_description[]" style="display:none;">';
echo $description;
echo '</textarea>';
            echo '<input type="checkbox" name="selected_videos[]" value="' . $id1 . '">
            <input type="hidden" name="selected_videos_name[]" value="' . $video->name . '">
            <input type="hidden" name="selected_videos_tag[]" value="' . $tagsString . '">

            <input type="hidden" name="selected_videos_date[]" value="' . date('Y', strtotime($video->created_time)) . '">
            <input type="hidden" name="selected_videos_type[]" value="' . $video->privacy->embed . '">
            
            <img src="' . $img_link . '" class="card-img-top" alt="Thumbnail">';
         
            echo '</div>';
            echo '<div class="card-body">';
            
            echo '<p class="card-text"><b>Created Date</b>: ' . date('d-m-Y', strtotime($video->created_time)) . '</p>';
               echo '<h5 class="card-title"><b>Title</b>: ' . $video->name . '</h5>';
             echo '<p class="card-text"><b>Short Bio</b>: ' . $video->user->short_bio . '</p>';
            echo '<p class="card-text"><b>Bio</b>: ' . $video->user->bio . '</p>';           
            echo '<p class="card-text"><b>Description</b>: ' . $video->description . '</p>';
              echo '<p class="card-text"><b>Release Date</b>: ' . date('d-m-Y H:i:s', strtotime($video->release_time)) . '</p>';
               
        echo '<p class="card-text"><b>Tags</b>: ' . $tagsString . '</p>';
            echo '</div>';
            echo '</div>';
            echo '</div>';
        }
        echo '</form>';
        // echo '</div>';
        
    } else {
        echo "<h2>No video data found.</h2>";
    }
}
// echo count($allVideos);
?>


            <!-- Your filterable content here -->
            <!-- You can use cards, divs, or any other HTML elements to display content -->
        </div>
    </div>
</div>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<!-- Include Bootstrap Datepicker JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>
<script>
    // Initialize datepickers
    $('.datepicker').datepicker({
        format: 'yyyy-mm-dd',
        autoclose: true
    });
    $('#query_fields').change(function() {
        // body...
        
    });
    $("form").submit(function(){
        if($('#query_fields').val() != '')
  {
    if( $('#query').val() == '')
    {
        alert('Please enter search');
        return false;
    }
    
  }
// alert();
// return false;
});
</script>
<style>
    .card {
    position: relative;
    display: -ms-flexbox;
    display: grid !important;
    grid-template-columns: repeat(2,1fr) !important;
    /* display: flex; */
    -ms-flex-direction: column;
    flex-direction: column;
    min-width: 0;
    word-wrap: break-word;
    background-color: #fff;
    background-clip: border-box;
    border: 1px solid rgba(0,0,0,.125);
    border-radius: 0.25rem;
}
</style>
<script>
    document.getElementById('select-all-checkbox').addEventListener('change', function () {
        var checkboxes = document.getElementsByName('selected_videos[]');
        for (var i = 0; i < checkboxes.length; i++) {
            checkboxes[i].checked = this.checked;
        }
    });
</script>
</body>
</html>
